VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cOuterBorders"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private RectSegments As cpSegmentShapeCollection, TextPath As cCairoPath

Public Sub Construct(ByVal X As Double, ByVal Y As Double, ByVal Width As Double, ByVal Height As Double, Optional ByVal Thickness = 2)
Dim TextSegments As cpSegmentShapeCollection, S As cpSegmentShape
  
  With PhEngine.ConstructionCC
    'this just demonstrates a handy feature of the Wrapper, you can basically use any
    'Cairo-CC-drawing-routine, to construct your chipmunk-shapes ... here we use a simple Rectangle-Call
    .Rectangle X, Y, Width, Height
    
    'Note, that we do *not* do any .Fill or .Stroke within here, we just need to feed the
    'Method below with the current Cairo-Path-Segments, which we retrieve per .CopyPath(True)
    Set RectSegments = PhEngine.StaticBody.CreateSegmentShapeCollectionFromPath(.CopyPath(True), Thickness)
  End With

  For Each S In RectSegments
    PhEngine.Space.AddStaticShape S, 0.05, 0.2 'here we iterate through the just added Shapes and add them statically to our Space
  Next S
End Sub

Public Sub Draw(CC As cCairoContext)
Dim S As cpSegmentShape

  CC.Save
  
    CC.SetLineCap CAIRO_LINE_CAP_SQUARE
    
    For Each S In RectSegments
      CC.DrawLine S.A_X, S.A_Y, S.B_X, S.B_Y
    Next S
      CC.SetLineWidth 1.9 * RectSegments.Thickness
      CC.SetSourceColor &HFFE0E0
    CC.Stroke
    
  CC.Restore
End Sub

